/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

float t = iGlobalTime;

float modulus1(vec2 rp) {
   rp.x -= 0.5 * t;
   vec2 m = mod(rp, 4.0) - vec2(2.0);
   return m.x * m.y;
}

float modulus2(vec2 rp) {
   rp.x -= 0.2 * t;
   vec2 m = mod(rp, 8.8) - vec2(4.4);
   return m.x * m.y;
}

float modulus3(vec2 rp) {
   rp.x += 0.7 * t;
   vec2 m = mod(rp, 2.4) - vec2(1.2);
   return abs(m.x * m.y);
}

// Standard hue rotation formula... compacted down a bit.
vec3 rotHue(vec3 p, float a){

    vec2 cs = sin(vec2(1.570796, 0.0) + a);

    mat3 hr =
      mat3(0.299, 0.587, 0.114, 0.299, 0.587, 0.114, 0.299, 0.587, 0.114)
    + mat3(0.701,-0.587,-0.114,-0.299, 0.413,-0.114,-0.300,-0.588, 0.886) * cs.x
    + mat3(0.168, 0.330,-0.497,-0.328, 0.035, 0.292, 1.250,-1.050,-0.203) * cs.y;

    return clamp(p*hr, 0., 1.);
}

vec4 colourJulia(vec2 p) {

   vec4 pc = vec4(0.0);

   float zoom = .9;
   float cmp = 0.086 + smoothstep(abs(sin(t) * 0.05), 0.0001, .677);
   // Shape of the Julia Set
   vec2 shape = vec2(-0.745, cmp);
   //orbit traps
   float trap1 = 1.0e20;
   float trap2 = 1.0e20;
   float trap3 = 1.0e20;

   vec2 z = abs(p) * zoom / dot(p, p);
   //you can see the set a bit more
   //vec2 z = abs(p) * zoom;

   vec2 dz = vec2(1., 0.);

   for(int i = 0; i < 256; i++) {

      dz = 2.0 * vec2(z.x * dz.x - z.y * dz.y, z.x * dz.y + z.y * dz.x);
      z = vec2(z.x * z.x - z.y * z.y, 2.0 * z.x * z.y) + shape;
      if (dot(z, z) > 200.0) break;

        trap1 = min(trap1, modulus1(z));
        trap2 = min(trap2, modulus2(z));
        trap3 = min(trap3, modulus3(z));
   }

    //colour model stolen from IQ fractals
    float c1 = pow(clamp(0.4 * trap1, 0.0, 1.0 ), 0.05);
    float c2 = pow(clamp(0.4 * trap2, 0.0, 1.0 ), 0.5);
    float c3 = pow(clamp(0.4 * trap3, 0.0, 1.0 ), 0.05);

    // Hue rotation
    vec4 mc = vec4(0.0, 0.0, 1.0, 1.0);
    mc.xyz = rotHue(mc.xyz, mod(t / 16., 6.283));

    vec4 col1 = vec4(0.5 + 0.5 * sin(4.1 + 2.0 * c1 + vec3(0.1, 0.0, 0.0)), .5);
    vec4 col2 = vec4(0.5 + 0.5 * sin(4.1 + 2.0 * c2 + vec3(0.0, 1.0, 0.0)), .5);
    vec4 col3 = vec4(0.5 + 0.5 * sin(4.1 + 2.0 * c3 + mc.xyz), .5);

    pc = col1 * 2.0;
    if (length(col2.xyz) > 0.0) {
        pc = mix(pc, col2, 0.5);
    }
    if (length(col3.xyz) > 0.0) {
        pc = mix(pc, col3 * 2.0, 0.5);
    }

    return pc;
}

void mainImage(out vec4 fragColor, in vec2 fragCoord) {

    vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;

    fragColor = colourJulia(uv);
}

void main ( void )
{
   mainImage ( gl_FragColor, gl_FragCoord.xy );
}
